unit ArrayQuestions_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math;

type
  TForm1 = class(TForm)
    btnQuestion1: TButton;
    btnQuestion2: TButton;
    btnQuestion3: TButton;
    btnQuestion4: TButton;
    lbxAnswer: TListBox;
    procedure btnQuestion1Click(Sender: TObject);
    procedure btnQuestion2Click(Sender: TObject);
    procedure btnQuestion3Click(Sender: TObject);
    procedure btnQuestion4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnQuestion1Click(Sender: TObject);
var
  aTimesTable: Array [1 .. 6, 1 .. 6] of Integer;
  j: Integer;
  k: Integer;
  line: String;
begin
  // create times table
  for j := 1 to length(aTimesTable) do
    for k := 1 to length(aTimesTable) do
      aTimesTable[j, k] := j * k;

  // Display
  lbxAnswer.clear;
  lbxAnswer.TabWidth := 20;
  line := '';
  for j := 1 to length(aTimesTable) do
  begin
    for k := 1 to length(aTimesTable) do
    begin
      line := line + IntToStr(aTimesTable[j, k]) + #09;
    end;
    lbxAnswer.Items.Add(line);
    line := '';
  end;

end;

procedure TForm1.btnQuestion2Click(Sender: TObject);
var
  aDigits: Array [1 .. 9, 1 .. 9] of Integer;
  j: Integer;
  k: Integer;
  line: String;
begin
  // create digits table
  for j := 1 to length(aDigits) do
    for k := 1 to length(aDigits) do
      aDigits[j, k] := randomRange(1, 10);

  // Display
  lbxAnswer.clear;
  lbxAnswer.TabWidth := 20;
  line := '';
  for j := 1 to length(aDigits) do
  begin
    for k := 1 to length(aDigits) do
    begin
      line := line + IntToStr(aDigits[j, k]) + #09;
    end;
    lbxAnswer.Items.Add(line);
    line := '';
  end;
end;

procedure TForm1.btnQuestion3Click(Sender: TObject);
var
  aSumIndices: Array [1 .. 10, 1 .. 5] of Integer;
  j: Integer;
  k: Integer;
  line: String;
begin
  // create digits table
  for j := 1 to length(aSumIndices) do
    for k := 1 to length(aSumIndices[1]) do
      aSumIndices[j, k] := j + k;

  // Display
  lbxAnswer.clear;
  lbxAnswer.TabWidth := 20;
  line := '';
  for j := 1 to length(aSumIndices) do
  begin
    for k := 1 to length(aSumIndices[1]) do
    begin
      line := line + IntToStr(aSumIndices[j, k]) + #09;
    end;
    lbxAnswer.Items.Add(line);
    line := '';
  end;
end;

procedure TForm1.btnQuestion4Click(Sender: TObject);
var
  aLowercaseChars: Array [1 .. 7, 1 .. 5] of char;
  j: Integer;
  k: Integer;
  line: String;
begin
  // create digits table
  for j := 1 to length(aLowercaseChars) do
    for k := 1 to length(aLowercaseChars[1]) do
      aLowercaseChars[j, k] := chr(randomRange(97, 123));

  // Display
  lbxAnswer.clear;
  lbxAnswer.TabWidth := 20;
  line := '';
  for j := 1 to length(aLowercaseChars) do
  begin
    for k := 1 to length(aLowercaseChars[1]) do
    begin
      line := line + aLowercaseChars[j, k] + #09;
    end;
    lbxAnswer.Items.Add(line);
    line := '';
  end;
end;

end.
